package org.msh.tb.bd.tbforms.indicator.tb10;

import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.msh.tb.bd.tbforms.query.TbFormQuery;
import org.msh.tb.bd.tbforms.query.tb10.TBForm10Block2Query;
import org.msh.tb.bd.tbforms.query.tb10.TBForm10Block5AQuery;
import org.msh.tb.entities.AdministrativeUnit;
import org.msh.tb.entities.Tbunit;
import org.msh.tb.entities.enums.*;
import org.msh.tb.indicators.core.Indicator2D;

import java.util.List;
import java.util.Map;

@Name("TBForm10Block5A")
public class TBForm10Block5A extends Indicator2D {

    TbFormQuery formQuery;

    @In(create=true) protected Map<String, String> messages;

	@Override
	protected void createIndicators() {
        initializeInterfaceTableRows();

        Tbunit tbunit = getIndicatorFilters().getTbunitselection().getSelected();
        AdministrativeUnit adminUnit = getIndicatorFilters().getTbunitselection().getLastLevelAdminUnitSelected();

        List<Object[]> result = getFormQuery().queryDB(tbunit,
                adminUnit,
                getWorkspace(),
                getIndicatorFilters().getQuarter(),
                getEntityManager());

        allocateValuesOnFields(result);
	}

    /**
     * Initialize the interface table. All cells should be there also if it's result is zero.
     */
    private void initializeInterfaceTableRows(){
        // row 1
        addValue("M1", "M", messages.get("manag.tbform10.block5A.row1title"), new Float(0).floatValue())
                .addCondition("p.gender = " + Gender.MALE.ordinal())
                .addCondition("(c.patientType = 0 or c.patientType = 48)")
                .addCondition("c.infectionSite = " + InfectionSite.PULMONARY.ordinal())
                .addCondition("c.caseDefinition = " + CaseDefinition.BACTERIOLOGICALLY_CONFIRMED.ordinal());

        addValue("F1", "F", messages.get("manag.tbform10.block5A.row1title"), new Float(0).floatValue())
                .addCondition("p.gender = " + Gender.FEMALE.ordinal())
                .addCondition("(c.patientType = 0 or c.patientType = 48)")
                .addCondition("c.infectionSite = " + InfectionSite.PULMONARY.ordinal())
                .addCondition("c.caseDefinition = " + CaseDefinition.BACTERIOLOGICALLY_CONFIRMED.ordinal());

        addValue(messages.get("global.total")+"1", messages.get("global.total"), messages.get("manag.tbform10.block5A.row1title"), new Float(0).floatValue())
                .addCondition("(c.patientType = 0 or c.patientType = 48)")
                .addCondition("c.infectionSite = " + InfectionSite.PULMONARY.ordinal())
                .addCondition("c.caseDefinition = " + CaseDefinition.BACTERIOLOGICALLY_CONFIRMED.ordinal());

        addValue("M2", "M", messages.get("manag.tbform10.block5A.row1title"), new Float(0).floatValue())
                .addCondition("p.gender = " + Gender.MALE.ordinal())
                .addCondition("(c.patientType = 0 or c.patientType = 48)")
                .addCondition("c.infectionSite = " + InfectionSite.PULMONARY.ordinal())
                .addCondition("c.caseDefinition = " + CaseDefinition.BACTERIOLOGICALLY_CONFIRMED.ordinal())
                .addCondition("hiv.result = 0");

        addValue("F2", "F", messages.get("manag.tbform10.block5A.row1title"), new Float(0).floatValue())
                .addCondition("p.gender = " + Gender.FEMALE.ordinal())
                .addCondition("(c.patientType = 0 or c.patientType = 48)")
                .addCondition("c.infectionSite = " + InfectionSite.PULMONARY.ordinal())
                .addCondition("c.caseDefinition = " + CaseDefinition.BACTERIOLOGICALLY_CONFIRMED.ordinal())
                .addCondition("hiv.result = 0");

        addValue(messages.get("global.total")+"2", messages.get("global.total"), messages.get("manag.tbform10.block5A.row1title"), new Float(0).floatValue())
                .addCondition("(c.patientType = 0 or c.patientType = 48)")
                .addCondition("c.infectionSite = " + InfectionSite.PULMONARY.ordinal())
                .addCondition("c.caseDefinition = " + CaseDefinition.BACTERIOLOGICALLY_CONFIRMED.ordinal())
                .addCondition("hiv.result = 0");

        // row 2
        addValue("M1", "M", messages.get("manag.tbform10.block5A.row2title"), new Float(0).floatValue())
                .addCondition("p.gender = " + Gender.MALE.ordinal())
                .addCondition("(c.patientType = 0 or c.patientType = 48)")
                .addCondition("c.infectionSite = " + InfectionSite.PULMONARY.ordinal())
                .addCondition("c.caseDefinition = " + CaseDefinition.CLINICALLY_DIAGNOSED.ordinal());

        addValue("F1", "F", messages.get("manag.tbform10.block5A.row2title"), new Float(0).floatValue())
                .addCondition("p.gender = " + Gender.FEMALE.ordinal())
                .addCondition("(c.patientType = 0 or c.patientType = 48)")
                .addCondition("c.infectionSite = " + InfectionSite.PULMONARY.ordinal())
                .addCondition("c.caseDefinition = " + CaseDefinition.CLINICALLY_DIAGNOSED.ordinal());

        addValue(messages.get("global.total")+"1", messages.get("global.total"), messages.get("manag.tbform10.block5A.row2title"), new Float(0).floatValue())
                .addCondition("(c.patientType = 0 or c.patientType = 48)")
                .addCondition("c.infectionSite = " + InfectionSite.PULMONARY.ordinal())
                .addCondition("c.caseDefinition = " + CaseDefinition.CLINICALLY_DIAGNOSED.ordinal());

        addValue("M2", "M", messages.get("manag.tbform10.block5A.row2title"), new Float(0).floatValue())
                .addCondition("p.gender = " + Gender.MALE.ordinal())
                .addCondition("(c.patientType = 0 or c.patientType = 48)")
                .addCondition("c.infectionSite = " + InfectionSite.PULMONARY.ordinal())
                .addCondition("c.caseDefinition = " + CaseDefinition.CLINICALLY_DIAGNOSED.ordinal())
                .addCondition("hiv.result = 0");

        addValue("F2", "F", messages.get("manag.tbform10.block5A.row2title"), new Float(0).floatValue())
                .addCondition("p.gender = " + Gender.FEMALE.ordinal())
                .addCondition("(c.patientType = 0 or c.patientType = 48)")
                .addCondition("c.infectionSite = " + InfectionSite.PULMONARY.ordinal())
                .addCondition("c.caseDefinition = " + CaseDefinition.CLINICALLY_DIAGNOSED.ordinal())
                .addCondition("hiv.result = 0");

        addValue(messages.get("global.total")+"2", messages.get("global.total"), messages.get("manag.tbform10.block5A.row2title"), new Float(0).floatValue())
                .addCondition("(c.patientType = 0 or c.patientType = 48)")
                .addCondition("c.infectionSite = " + InfectionSite.PULMONARY.ordinal())
                .addCondition("c.caseDefinition = " + CaseDefinition.CLINICALLY_DIAGNOSED.ordinal())
                .addCondition("hiv.result = 0");

        // row 3
        addValue("M1", "M", messages.get("manag.tbform10.block5A.row3title"), new Float(0).floatValue())
                .addCondition("p.gender = " + Gender.MALE.ordinal())
                .addCondition("(c.patientType = 0 or c.patientType = 48)")
                .addCondition("c.infectionSite = " + InfectionSite.EXTRAPULMONARY.ordinal());

        addValue("F1", "F", messages.get("manag.tbform10.block5A.row3title"), new Float(0).floatValue())
                .addCondition("p.gender = " + Gender.FEMALE.ordinal())
                .addCondition("(c.patientType = 0 or c.patientType = 48)")
                .addCondition("c.infectionSite = " + InfectionSite.EXTRAPULMONARY.ordinal());

        addValue(messages.get("global.total")+"1", messages.get("global.total"), messages.get("manag.tbform10.block5A.row3title"), new Float(0).floatValue())
                .addCondition("(c.patientType = 0 or c.patientType = 48)")
                .addCondition("c.infectionSite = " + InfectionSite.EXTRAPULMONARY.ordinal());

        addValue("M2", "M", messages.get("manag.tbform10.block5A.row3title"), new Float(0).floatValue())
                .addCondition("p.gender = " + Gender.MALE.ordinal())
                .addCondition("(c.patientType = 0 or c.patientType = 48)")
                .addCondition("c.infectionSite = " + InfectionSite.EXTRAPULMONARY.ordinal())
                .addCondition("hiv.result = 0");

        addValue("F2", "F", messages.get("manag.tbform10.block5A.row3title"), new Float(0).floatValue())
                .addCondition("p.gender = " + Gender.FEMALE.ordinal())
                .addCondition("(c.patientType = 0 or c.patientType = 48)")
                .addCondition("c.infectionSite = " + InfectionSite.EXTRAPULMONARY.ordinal())
                .addCondition("hiv.result = 0");

        addValue(messages.get("global.total")+"2", messages.get("global.total"), messages.get("manag.tbform10.block5A.row3title"), new Float(0).floatValue())
                .addCondition("(c.patientType = 0 or c.patientType = 48)")
                .addCondition("c.infectionSite = " + InfectionSite.EXTRAPULMONARY.ordinal())
                .addCondition("hiv.result = 0");

        // row 4
        addValue("M1", "M", messages.get("manag.tbform10.block5A.row4title"), new Float(0).floatValue())
                .addCondition("p.gender = " + Gender.MALE.ordinal())
                .addCondition("( c.patientType = 44 and c.previouslyTreatedType in (1,45,46,47))");

        addValue("F1", "F", messages.get("manag.tbform10.block5A.row4title"), new Float(0).floatValue())
                .addCondition("p.gender = " + Gender.FEMALE.ordinal())
                .addCondition("( c.patientType = 44 and c.previouslyTreatedType in (1,45,46,47))");

        addValue(messages.get("global.total")+"1", messages.get("global.total"), messages.get("manag.tbform10.block5A.row4title"), new Float(0).floatValue())
                .addCondition("( c.patientType = 44 and c.previouslyTreatedType in (1,45,46,47))");

        addValue("M2", "M", messages.get("manag.tbform10.block5A.row4title"), new Float(0).floatValue())
                .addCondition("p.gender = " + Gender.MALE.ordinal())
                .addCondition("( c.patientType = 44 and c.previouslyTreatedType in (1,45,46,47))")
                .addCondition("hiv.result = 0");

        addValue("F2", "F", messages.get("manag.tbform10.block5A.row4title"), new Float(0).floatValue())
                .addCondition("p.gender = " + Gender.FEMALE.ordinal())
                .addCondition("( c.patientType = 44 and c.previouslyTreatedType in (1,45,46,47))")
                .addCondition("hiv.result = 0");

        addValue(messages.get("global.total")+"2", messages.get("global.total"), messages.get("manag.tbform10.block5A.row4title"), new Float(0).floatValue())
                .addCondition("(c.patientType = 44 and c.previouslyTreatedType in (1,45,46,47))")
                .addCondition("hiv.result = 0");

    }

    /**
     * Include the values from the result object to the interface table object
     * @param result the result to be included on interface table
     */
    private void allocateValuesOnFields(List<Object[]> result){
        for(Object[] r : result){
            InfectionSite is = (InfectionSite) r[0];
            PatientType pt = (PatientType) r[1];
            CaseDefinition cd = (CaseDefinition) r[2];
            Gender gender = (Gender) r[3];
            HIVResult hiv = (HIVResult) r[4];
            Long qtd = (Long) r[5];

            if(pt.equals(PatientType.NEW) || pt.equals(PatientType.UNKNOWN_PREVIOUS_TB_TREAT)){

                String row = null;
                if (InfectionSite.EXTRAPULMONARY.equals(is)) {
                    row = "3";
                } else if (InfectionSite.PULMONARY.equals(is) && CaseDefinition.BACTERIOLOGICALLY_CONFIRMED.equals(cd)) {
                    row = "1";
                } else if (InfectionSite.PULMONARY.equals(is) && CaseDefinition.CLINICALLY_DIAGNOSED.equals(cd)) {
                    row = "2";
                }

                if(gender.equals(gender.MALE))
                    addValue("M1", "M", messages.get("manag.tbform10.block5A.row"+row+"title"), qtd.floatValue());
                else if(gender.equals(gender.FEMALE))
                    addValue("F1", "F", messages.get("manag.tbform10.block5A.row"+row+"title"), qtd.floatValue());
                addValue(messages.get("global.total")+"1", messages.get("global.total"), messages.get("manag.tbform10.block5A.row"+row+"title"), qtd.floatValue());

                if(hiv.equals(HIVResult.POSITIVE)){
                    if(gender.equals(gender.MALE))
                        addValue("M2", "M", messages.get("manag.tbform10.block5A.row"+row+"title"), qtd.floatValue());
                    else if(gender.equals(gender.FEMALE))
                        addValue("F2", "F", messages.get("manag.tbform10.block5A.row"+row+"title"), qtd.floatValue());
                    addValue(messages.get("global.total")+"2", messages.get("global.total"), messages.get("manag.tbform10.block5A.row"+row+"title"), qtd.floatValue());
                }
            }else{
                if(gender.equals(gender.MALE))
                    addValue("M1", "M", messages.get("manag.tbform10.block5A.row4title"), qtd.floatValue());
                else if(gender.equals(gender.FEMALE))
                    addValue("F1", "F", messages.get("manag.tbform10.block5A.row4title"), qtd.floatValue());
                addValue(messages.get("global.total")+"1", messages.get("global.total"), messages.get("manag.tbform10.block5A.row4title"), qtd.floatValue());

                if(hiv.equals(HIVResult.POSITIVE)){
                    if(gender.equals(gender.MALE))
                        addValue("M2", "M", messages.get("manag.tbform10.block5A.row4title"), qtd.floatValue());
                    else if(gender.equals(gender.FEMALE))
                        addValue("F2", "F", messages.get("manag.tbform10.block5A.row4title"), qtd.floatValue());
                    addValue(messages.get("global.total")+"2", messages.get("global.total"), messages.get("manag.tbform10.block5A.row4title"), qtd.floatValue());
                }
            }
        }
    }

    private TbFormQuery getFormQuery() {
        if (formQuery == null) {
            formQuery = new TBForm10Block5AQuery();
        }

        return formQuery;
    }

}
